/*------------------------------------------------------------------------------*
 *	File Name: 	oc_sys.h														*
 *	Purpose:	Basic and common oc and Origin internal const and typedef		*
 *	Author:		CPY																*
 *  Date:		10-26-2005 														*
 *  Copyright OriginLab Corp. 2005												*
 *																				*
 *	Modification Log															*
 *		YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS	*
 *		DSC 10/28/2005 SUPPORT_ORIGIN_PATH_UNDEF								*
 *		YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES			*
 *	CPY 12/26/05 GETNGRAPH_BOX_TYPE_4											*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	ML 2/10/2006 QA70-8490 NEW_VC_TREE_CONTROL									*
 *	TD 2-14-06 QA70-8490 GETN_EVENTS_IN_TREE_DLG								*
 *	ML 2/17/2006 INTERACTIVE_CONTROL_MENUS										*
 *	YuI 03/24/06 STRING_VECTOR_X_VARIABLE										*
 *	YuI 03/30/06 COMPLEX_VECTOR_AND_RANGE_DATA_TYPES							*
 *	RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS							*
 *	ML 4/21/2006 QA70-8634 USING_TAGNAMES_INSTEAD_OF_DATAIDS_IN_SOME_CASES		*
 *	ML 4/25/2006 ACTION_OBJECT_COMPOSITE_NODES_ETC								*
 *	TD 5-30-06 QA70-8708 MORE_CROSS_EVENTS_FOR_XFNS								*
 *	TD 6-2-06 QA70-8708 CALLING_BEFORE_EXECUTE_EVENT							*
 *	ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY								*
 *	YuI 08/30/06 QA70-8944 IMAGE_TYPE_XVARIABLE									*
 *	Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH						*
 *	ML 6/1/2006 OPTIONALLY_PUTTING_MULTIPLE_ITEMS_OF_ONE_NODE_INTO_SUBPOPUP		*
 *  SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *	ML 10/19/2006 ADDING_NON_XFUNC_MENU_ITEMS_VIA_MENU_TREE						*
 *	ML 11/13/2006 QA70-9125 SETREPORTTREE_SETTING_COLUMN_DIGITMODE_DIGITS		*
 *	RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO							*
 *	Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS							*
 *	Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY							*
 *  SY 2007-02-13 QA70-9361 v8.0561 COL_LOCKED_CAN_NOT_INSERT					*
 *	TD YuI 4-26-07 QA80-9576 ADD_MORE_DETAILED_PREDIFINED_MENU_ENTRIES			*
 *	AW 05/23/07 QA80-9821 v8.0622 SUPPORT_GETN_OC_EVENT							*
 *	Jake 06/18/07 v8.0643 GET_PATH_TRACK_LIST_FROM_REGISTRY						*
 *	Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW					*
 *	Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE							*
 *	CPY 7/18/2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE
 *	Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD							*
 *	Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING				*
 *	DSC 8/14/07 QA70-10217 VIEW_LICENSE_AGREEMENT_IN_ORIGIN						*
 *	Hong 09/14/07 QA80-10111 GROUP_DEFAULT_TO_UFF_SUBFOLDER						*
 *	CPY 10/26/2007 SOME_LOCALIZATION_NOT_ADDED_TO_OLOCAL						*
 *	Folger 11/05/07 SAVE_XF_DIALOG_INFO_IN_PAGE_STORAGE							*
 *	EJP 2007-11-05 v8.0741 LOCALIZE_PKG_BUILDER_TREE							*
 *	Sim 11-05-2007 CLEAN_LOCALIZATION_CODE										*
 *	Folger 11/09/07 LOCALIZE_DATARANAGE_RELATED_LABEL							*
 *	Folger 11/09/07 LOCALIZE_PLOT_DETAIL_STRETCH								*
 *	Folger 11/09/07 LOCALIZE_ANOVA_RELATED_LABEL								*
 *	Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES									*
 *	Hong 11/10/07 QA80-10664 FIX_AUTO_CONTROL_FAIL_UPDATE_IF_HAVE_EVENT_HANDLER	*
 *	Folger 11/16/07 LOCALIZE_INCREMENT_EDITOR_MENU								*
 *	Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO									*
 *	Folger 11/20/07 LOCALIZD_RANGE_STRING_BUILDER_TITLE							*
 *	RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE							*
 *	Folger 12/03/07 LOCALIZE_MARTIX_WINDOW_MENU									*
 *	ML 12/3/2007 MENU_LEVEL_TITLES_LOCALIZATION									*
 *	RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR				*
 *	Folger 12/05/07 LOCALIZE_UPDATE_TABLE_GRAPH_OBJECT							*
 *	ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE								*
 *	Hong 12/06/07 v8.0762 IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
 *	Folger 12/11/07 LOCALIZE_FINISH_STEP_OF_PFW									*
 *	Folger 01/08/08 LOCALIZE_MENU_KEYWORD_COMMAND								*
 *	ML 1/25/2008 QA70-10972-P4 ADO_EXCEPTION_ON_EMPTY_RECORDSET					*
 *	CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT			*
 *	EJP 2008-06-05 v8.0879 QA80-11658 ADD_UNINSTALL_SCRIPT_TO_OPX				*
 *	CPY 7/31/08 QA70-11914-P10 SEPARATE_OUT_AUTO_X_INSTEAD_OF_AUTO_IN_SAMPLING_INTERVAL_X
 *	Sim 09-08-2008 DEFAULT_VERSION_NUMBER_FOR_XF_WIZARD							*
 *	Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE				*
 *	Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE			*
 *	YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS									*
 *	Folger 02/09/09 QA80-12786 NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE
 *	Folger 02/20/09 CORRECTLY_LOCALIZE_MATRIX_LAYER_ACTION_MENU					*
 *	Sim 03-24-2009 QA70-13034 CUSTOM_XF_DIALOGS_FOR_81							*
 *	YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT								*
 *	Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
 *	Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING	*
 * Kenny 05/06/2009 NEW_FEATURE_VERTICAL_CURSOR									*
 *	Sim 05-07-2009 QA80-13571 FIX_CRASH_WHEN_FILE_PATH_LENGTH_IS_TOO_LONG		*
 *	Hong 05/08/09 ADD_IFDEF_FOR_SR6												*
 *	Hong 04/27/09 QA80-8454 SUPPORT_MORE_WKS_DATA_MANIPULATION_CAPABILITIES		*
 * Kenny 06/25/2009 QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE*
 *	Kyle 07/02/2009 QA70-13423 NEW_FILE_TYPE_FOR_MENU_CUSTOMIZATION				*
 *	Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER			*
 *	Folger 08/12/09 QA80-14130 NEW_UFF2_AS_SYSTEM_TEMP_NEEDED					*
 *	Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS			*
 *	YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION						*
 *	Folger 12/30/09 QA81-14903 MRU_MENU_FOR_QUICK_FIT							*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *	Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
 *	Kyle 03/30/2010 QA80-15216 FUNCTION_MENU_FOR_FUNCTION_PLOT					*
 *	Kenny 06/18/2010 ORG-345-P1 ADD_LAYER_AS_XF_DATA_TYPE_FOR_XF_PALAPPLY		*
 *	Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS		*
 *	Folger 08/19/10 ORG-756-P3 BETTER_CHECKING_FOR_VALID_EQUATIONS				*
 *	Folger 08/19/10 ORG-279-P24 LOCALIZATION_FOR_SEMITRANSPARENT_IN_EXPGRAPH	*
 *	Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT					*
 *------------------------------------------------------------------------------*/



#ifndef _OC_SYS_H_
#define _OC_SYS_H_

#ifdef __AFX_H__
	//-----CPY 10/26/2007 SOME_LOCALIZATION_NOT_ADDED_TO_OLOCAL
	#define _LOCALIZED(x)	(x)
	#define		_OL(_arg)		_arg
	#define		_LE(_arg)		_arg
	//-----
#else	//!__AFX_H__
	//-----CPY 10/26/2007 SOME_LOCALIZATION_NOT_ADDED_TO_OLOCAL
	// replace all _LOCALIZED as _OL
	//#define _LOCALIZED(x)	_L(x)
	//#define _LOCALIZED(x)	GetLocalized(x)
	//-----
#endif	//!__AFX_H__

typedef enum	tagTHEMETYPE
{
	THTYPE_UNDEF = 0,
	THTYPE_GRAPH = 1,
	THTYPE_WORKSHEET,
	THTYPE_MATRIX,
	THTYPE_ANALYSIS,
	THTYPE_DIALOG,
	THTYPE_REPORT_TABLE,
	THTYPE_FB_FILTER,	// Function Browser themes
	THTYPE_CUSTOM,
	THTYPE_EVENT_ORGANIZER,
	THTYPE_MENU,
	THTYPE_XFUNCTION, ///DSC 8/1/05 ANALYSIS_XF_THEME_TYPE
	THTYPE_TABLE,	/// RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS
}	THEMETYPE;

///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
#define		STR_THEME_NAME_NULL 	"Untitled"
#define 	STR_CLASS_OPTION_NULL	"Unknown"
enum {
	THTYPESCOPE_UNDEF = -1,
   THTYPESCOPE_ANALYSIS_CLASS, // for class specific
   THTYPESCOPE_ANALYSIS_CATEGORY, //for a particular category
   THTYPESCOPE_ANALYSES_COMMON //for all analysis       
};

///End ADD_THEME_SAVE_AS_BOX

#define STR_PRO_POSTFIX			_L("(Pro)") /// Iris 8/21/2009 QA80-14165 SHOW_PRO_CONTROL_WITH_DISABLE_AND_PRO_TAG

#define THEME_FILE_NODE_NAME 	"File"
#define THEME_TYPE_ATTRIBUTE 	"Type"

#define THEME_FILENAME_DEFAULT			"Default"
#define THEME_FILENAME_COPY				"Copy"
#define	THEME_FILENAME_NO_CLASS			"Common"

#define STR_AUTOX	_OL("<autoX>")	//---- CPY 7/31/08 QA70-11914-P10 SEPARATE_OUT_AUTO_X_INSTEAD_OF_AUTO_IN_SAMPLING_INTERVAL_X

#define STR_AUTO	_OL("<auto>")	//---- CPY 7/10/06 QA70-8806 AUTO_SUPPORT_FOR_XF_VAR_VALUES
#define STR_FIT_CURVE					_OL("<fittedvalue>")	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH ///Arvin 12/29/06 MODIFY_BY_MAX_SUGGESTION

/// YuI 07/31/08 QA70-11930 REPLACE_POUND_WITH_AUTOX
#define	USE_ROW_NUMBER_SPECIAL_CHARACTER	STR_AUTOX
/// end REPLACE_POUND_WITH_AUTOX

///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX 
//label to indicate layer has no layer name
#define STR_NO_NAME						_OL("<No Name>")
#define STR_NO_NAME_E					_LE("<No Name>")
///End USE_REAL_LAYER_NAME_NOT_INDEX
#define STR_NONE						_OL("<none>")
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
#define STR_NONE_E						_LE("<none>")
///---END CLEAN_LOCALIZATION_CODE
/// Iris 02/27/2007 v8.0571 CHANGE_FIRST_CHAR_TO_UPPER
//#define STR_LAST_USED					_OL("<last used>")
//#define THEME_FILENAME_LAST_USED		"last used"
#define STR_LAST_USED					_OL("<Last used>")
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
#define STR_LAST_USED_E					_LE("<Last used>")
///---END CLEAN_LOCALIZATION_CODE
#define THEME_FILENAME_LAST_USED		"Last used"
///end CHANGE_FIRST_CHAR_TO_UPPER

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
#define STR_FOLDER_LAST_USED					_OL("<Folder last used>")
#define STR_FOLDER_LAST_USED_E					_LE("<Folder last used>")
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

#define THEME_FILENAME_FACTORY_DEFAULT	_OL("<Factory default>")
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
#define THEME_FILENAME_FACTORY_DEFAULT_E	_LE("<Factory default>")
///---END CLEAN_LOCALIZATION_CODE

//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
//#define STR_THEME_FACTORY_DEFAULT "1" //------ CPY 6/5/2007 QA70-9803 SHIFT_SELECT_SHOULD_FORCE_DIALOG_TO_OPEN
#define STR_THEME_DEFAULT_SHORT_FORM "1"
#define STR_THEME_NONE				 ""
#define STR_DEFAULT 					_OL("<default>")
#define STR_DEFAULT_E					_LE("<default>")
//-------

/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
#define STR_BOOK						_OL("<book>")
#define STR_SHEET						_OL("<sheet>")
/// end XF_THEME_BOOK_AND_SHEET
/// Iris 12/11/2006 EXPORT_PAGE_SUPPORT_MUL_PAGES
#define STR_LONG_NAME					_OL("<long name>")
#define STR_SHORT_NAME					_OL("<short name>")
///end EXPORT_PAGE_SUPPORT_MUL_PAGES

///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC	taken from analysis_utile.h
// *** Common ***
#define STR_TOKEN_SEP					"|"
#define STR_SOURCE_BOOK					_OL("<source>")
#define STR_REPORT						_OL("<report>")
#define STR_INSERT_SOURCE_SHEET			STR_SOURCE_BOOK
/// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
//#define STR_CUSTOM						_OL("<custom>")  ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
#define STR_EXISTING					_OL("<existing>")
#define STR_CUSTOM						STR_EXISTING
///---Sim 11-05-2007 CLEAN_LOCALIZATION_CODE
#define STR_EXISTING_E					_LE("<existing>")
#define STR_CUSTOM_E					STR_EXISTING_E
///---END CLEAN_LOCALIZATION_CODE
/// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
#define	STR_UNASSIGNED					_OL("<unassigned>")
#define	STR_UNASSIGNED_SHORT			"<>"
#define STR_THREE_DOTS					"..."  ///Iris 11/16/04 
/// Hong 12/06/07 v8.0762 IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
#define STR_EXE_FOLDER					_OL("<Origin Folder>")
/// end IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
//----Jake 06/18/07 v8.0643 GET_PATH_TRACK_LIST_FROM_REGISTRY
#define STR_USER_FOLDER					_OL("<User File Folder>")
#define STR_PROJECT_FOLDER				_OL("<Project Folder>")
//----end GET_PATH_TRACK_LIST_FROM_REGISTRY
/// YuI 08/12/05 QA70-8006 XFUNCTION_AND_TREE_VARIABLE
#define	STR_OPTIONAL					_OL("<optional>")
/// end XFUNCTION_AND_TREE_VARIABLE

//------ Folger 01/08/08 LOCALIZE_MENU_KEYWORD_COMMAND
#define L_STR_OPTIONAL					_LL("<optional>")
//------

/// TD YuI 4-26-07 QA80-9576 ADD_MORE_DETAILED_PREDIFINED_MENU_ENTRIES
//-------- CPY 11/03/2007 SOME_ACTION_MENU_NOT_LOCALIZED
//#define	STR_INPUT_DISPXY				_OL("<input>: XY = input XY")
//#define	STR_INPUT_NEW					_OL("(<input>,<new>)")
//#define	STR_INPUT_NEW_DISPXY			_OL("(<input>,<new>): X = Input X, Y = New Column")
#define L_STR_INPUT_DISPXY		_LL("<input>: XY = input XY")
#define L_STR_INPUT_NEW_DISPXY	_LL("(<input>,<new>): X = Input X, Y = New Column")
#define L_STR_INPUT_NEW			_LL("(<input>,<new>)")

#define STR_ACTIVE				_OL("<active>")
#define L_STR_ACTIVE			_LL("<active>")

#define STR_NEW					_OL("<new>")
#define L_STR_NEW				_LL("<new>")

#define	STR_INPUT				_OL("<input>")
#define L_STR_INPUT				_LL("<input>")

#define	STR_SAME				_OL("<same>")
#define	L_STR_SAME				_LL("<same>")

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define STR_MORE_EX				_OL("<more>")
#define L_STR_MORE_EX			_LL("<more>")
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU

#define	STR_MORE				_OL("&More...")
#define L_STR_MORE				_LL("&More...") // CPY I found this already in oLocalJ so must have been used already

#define E_USER					_LE("User")
#define E_SYSTEM				_LE("System")
#define E_GROUP					_LE("Group")
#define E_UNKNOWN				_LE("Unknown")
#define E_PROJECT				_LE("Project")
#define E_WORKING				_LE("Working")

//------ Folger 11/09/07 LOCALIZE_DATARANAGE_RELATED_LABEL
#define	E_STR_ERROR_BAR_WEIGHT_DATARANGE		_LE("Error Bar / Weight")
#define E_STR_DEPENDENT_DATA					_LE("Dependent Data")
#define E_STR_INDEPENDENT_DATA					_LE("Independent Data")
#define E_STR_X_DATA_RANGE						_LE("X Data Range")
#define E_STR_Y_DATA_RANGE						_LE("Y Data Range")
#define E_STR_Z_DATA_RANGE						_LE("Z Data Range")
#define E_STR_DATA_RANGE						_LE("Data Range")
#define E_STR_GROUPING_RANGE					_LE("Grouping Range")
#define E_STR_WEIGHTING_RANGE					_LE("Weighting Range")
#define E_STR_TIME								_LE("Time")
#define E_STR_CENSOR							_LE("Censor")
#define E_STR_COVARIANCE						_LE("Covariance")
#define E_STR_DATA								_LE("Data")
#define E_STR_STATE								_LE("State")
//------ End LOCALIZE_DATARANAGE_RELATED_LABEL

/// YuI 03/23/09 QA70-12160 XYRANGE_XERROR_SUPPORT
#define	E_STR_X_ERROR_DATARANGE		_LE("X Error")
/// end XYRANGE_XERROR_SUPPORT


#define E_STR_STRETCH							_LE("None|By One|Stretch")	//------ Folger 11/09/07 LOCALIZE_PLOT_DETAIL_STRETCH

//------ Folger 11/09/07 LOCALIZE_ANOVA_RELATED_LABEL
#define E_STR_FACTOR							_LE("Factor")
#define E_STR_NAME								_LE("Name")
#define E_STR_LEVEL								_LE("Level")
#define E_STR_SUBJECT							_LE("Subject")
#define E_STR_REPEAT							_LE("Repeat")
//------ End LOCALIZE_ANOVA_RELATED_LABEL

/// RVD 11/29/2007 v8.0758 WKS_STYLES_MENU_TRANSLATE
#define E_STR_STANDARD							_LE("Standard")
#define E_STR_COLHEADER							_LE("Column Header")
#define E_STR_ROWHEADER							_LE("Row Header")
#define E_STR_LABEL								_LE("Labels")
#define E_STR_COLLABEL							_LE("Column Labels")
#define E_STR_ROWLABEL							_LE("Row Labels")
#define E_STR_ROWCOLLABEL						_LE("Row and Column Labels")
#define E_STR_SEPARATOR							_LE("Separators")
#define E_STR_TABLETAG							_LE("Table Tags")
#define E_STR_DATAMASK							_LE("Data Mask")
#define E_STR_PRINTAREAMASK						_LE("Print Area Mask")
//#define E_STR_DATA								_LE("Data") CPY this is already defined above
#define E_STR_FOOTNOTE							_LE("Footnotes")
#define E_STR_HEADER							_LE("Headers")
#define E_STR_URL								_LE("URLs")
#define E_STR_EMBED								_LE("Embeddings")
/// end WKS_STYLES_MENU_TRANSLATE

/// RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR
#define	E_STR_THEME_ERROR_UNKNOWN				_LE("Unknown theme error")
#define	E_STR_THEME_ERROR_MEMORY				_LE("Memory theme error")
#define	E_STR_THEME_ERROR_SETSTYLE				_LE("Set theme error")
#define	E_STR_THEME_ERROR_GETSTYLE				_LE("Get theme error")
#define	E_STR_THEME_ERROR_STRUCTURE				_LE("Structure theme error")
#define	E_STR_THEME_ERROR_INSERTBRANCH			_LE("Insert branch theme error")
#define	E_STR_THEME_ERROR_INSERTLEAF			_LE("Insert leaf theme error")
#define	E_STR_THEME_ERROR_INSERTVALUE			_LE("Insert value theme error")
#define	E_STR_THEME_ERROR_SETVALUE				_LE("Set value theme error")
#define	E_STR_THEME_ERROR_CLIPBOARD				_LE("Clipboard theme error")
#define	E_STR_THEME_ERROR_ELEMENT				_LE("Element theme error")
#define	E_STR_THEME_ERROR_TRANSLATE				_LE("ID translation theme error")
#define	E_STR_THEME_ERROR_SETINDEX				_LE("Set Index theme error")
#define	E_STR_THEME_ERROR_CONVERT				_LE("Convert theme error")
#define	E_STR_THEME_ERROR_CREATE				_LE("Create theme error")
#define	E_STR_THEME_ERROR_XML					_LE("XML theme error")
/// end FIX_THEME_LIMIT_REACHED_ERROR

//------ Folger 11/09/07 LOCALIZE_BUILD_IN_LABLES
#define E_STR_LONGNAME							_LE("Long Name")
#define E_STR_UNITS								_LE("Units")
#define E_STR_COMMENTS							_LE("Comments")
#define E_STR_PARAMETERS						_LE("Parameters")
#define E_STR_SAMPLING_INTERVAL					_LE("Sampling Interval")
#define E_STR_SPARKLINES						_LE("Sparklines")
#define E_STR_USER_DEFINED_PARAMETERS			_LE("User-Defined Parameters")
//------ End LOCALIZE_BUILD_IN_LABLES

#define STR_UDL_PREFIX							"UserDefined"

//------ Folger 11/16/07 LOCALIZE_INCREMENT_EDITOR_MENU
#define E_STR_OPEN_PALETTE_EDITOR				_LE("Open in palette editor")
#define E_STR_LOAD_PALETTE						_LE("Load palette")
//------ End LOCALIZE_INCREMENT_EDITOR_MENU

//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
#define E_STR_IMPORT_HEADER						_LE("Header")
#define E_STR_IMPORT_SUBHEADER					_LE("SubHeader")
//------ End LOCALIZE_IMPORT_FILE_INFO

//------ Folger 12/03/07 LOCALIZE_MARTIX_WINDOW_MENU
#define E_STR_MORE								_LE("More")
#define E_STR_MATRICES							_LE("Matrices")
#define E_STR_ENTER_NEW_NAME					_LE("Enter a new name")
//------

//------ Folger 12/05/07 LOCALIZE_UPDATE_TABLE_GRAPH_OBJECT
#define E_STR_UPDATE_TABLE						_LE("Update Table")
//------

//------ Folger 12/11/07 LOCALIZE_FINISH_STEP_OF_PFW
#define E_STR_FINISH							_LE("Finish")
//------

//---- CPY 2/20/2008 QA70-11140 CELL_EMBED_LINK_LT_NOTATION_PROPER_UPDATE
#define E_STR_EMBEDDING	"embedding"
#define E_STR_LINKING	"linking"
//----

#define	WKSH_OPERATION_INFO_DATA_MODE	_LL("Multi-Data Fit Mode")

#define L_STR_SEL_DATA_IN_GRAPH _LL("Select data in graph")
#define L_STR_SEL_DATA_IN_WKS	_LL("Select data in worksheet")
#define L_STR_INDEP_COL_COMBINED	_LL("Independent Columns|Combined as Single Dataset")
#define L_STR_FIT_MODES_COMBO		_LL("Independent Fit - Consolidated Report|Independent Fit - Separate Report|Concatenate Fit|Global Fit")
#define L_STR_FIT_REPORT_MODE_COMBO _LL("Independent - Consolidated Report|Independent - Separate Reports|Concatenate")

//---------

/// end ADD_MORE_DETAILED_PREDIFINED_MENU_ENTRIES

/// EJP 2007-11-05 v8.0741 LOCALIZE_PKG_BUILDER_TREE
#define L_STR_PACKAGE			_LL("Package")
#define L_STR_MODULE_NAME		_LL("Module Name")
#define L_STR_DESCRIPTION		_LL("Description")
#define L_STR_VERSION			_LL("Version")
#define L_STR_AUTHOR			_LL("Author")
#define L_STR_VER_REQUIRED		_LL("Origin Version Required")
#define L_STR_TARGET_PATH		_LL("Target Path")
#define L_STR_TOOLBAR			_LL("Toolbar")
#define L_STR_BUTTON_GRP_FILE	_LL("Button Group File")
#define L_STR_CREATE_TOOLBAR	_LL("Create Toolbar")
#define L_STR_LT_SCRIPT			_LL("LabTalk Script")
#define L_STR_BEFORE_INSTALL	_LL("Before Installation")
#define L_STR_AFTER_INSTALL		_LL("After Installation")
#define L_STR_BEFORE_UNINSTALL	_LL("Before UnInstalling") /// EJP 2008-06-05 v8.0879 QA80-11658 ADD_UNINSTALL_SCRIPT_TO_OPX
#define L_STR_SRC_PATH			_LL("Source Path")
#define L_STR_UNTITLED			_LL("Untitled")
#define L_STR_ENTER_TEXT		_LL("Enter text here")
#define L_STR_TARGET_PATH_LIST	_LL("User|System|Auto")
/// end	LOCALIZE_PKG_BUILDER_TREE
/// ML 12/3/2007 MENU_LEVEL_TITLES_LOCALIZATION
#define L_STR_FULL_MENUS		_LL("Full Menus")
#define L_STR_SHORT_MENUS		_LL("Short Menus")
/// end MENU_LEVEL_TITLES_LOCALIZATION

#define L_STR_RANGE_STRING_BUILDER	_LL("Range string builder")		//------ Folger 11/20/07 LOCALIZD_RANGE_STRING_BUILDER_TITLE

///------ Folger 02/20/09 CORRECTLY_LOCALIZE_MATRIX_LAYER_ACTION_MENU
#define	MATRIX_LAYER_ACTION_MENU_ADD_CAPTION_LOCALIZED		_LC("Add", "MatLyrActMenu")
///------ End CORRECTLY_LOCALIZE_MATRIX_LAYER_ACTION_MENU

/// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
#define	STR_NAME_ENGLISH				"name"
#define	STR_TEMPLATE_ENGLISH			"template"
#define	STR_SHOW_ENGLISH				"show"
#define STR_INDEX_ENGLISH				"index" //----- CPY 2/20/06 RANGE_ADD_COL_BY_INDEX_SHOULD_NOT_PUT_INDEX_INTO_LONG_NAME
//---- CPY 10/26/2007 SOME_LOCALIZATION_NOT_ADDED_TO_OLOCAL
// I don't think these should be localized
//#define	STR_NAME						_LOCALIZED(STR_NAME_ENGLISH)
//#define	STR_TEMPLATE					_LOCALIZED(STR_TEMPLATE_ENGLISH)
//#define STR_INDEX						_LOCALIZED(STR_INDEX_ENGLISH)
//#define	STR_SHOW						_LOCALIZED(STR_SHOW_ENGLISH)
#define	STR_NAME		STR_NAME_ENGLISH	//				_LOCALIZED(STR_NAME_ENGLISH)
#define	STR_TEMPLATE	STR_TEMPLATE_ENGLISH	//				_LOCALIZED(STR_TEMPLATE_ENGLISH)
#define STR_INDEX		STR_INDEX_ENGLISH	//				_LOCALIZED(STR_INDEX_ENGLISH)
#define	STR_SHOW		STR_SHOW_ENGLISH	//				_LOCALIZED(STR_SHOW_ENGLISH)
//----

//----
/// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS


#define STR_TEMPLATE_THEME				_OL("<page storage>")//--- CPY 7/18/2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE

/// ML 2/10/2006 QA70-8490 NEW_VC_TREE_CONTROL
#define STR_COMBO_CHANGED	"ComboChanged" //---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED
/// end NEW_VC_TREE_CONTROL

///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC

/// YuI 08/15/06 MORE_WORK_ON_STATISTICAL_PLOTS
// moved from okconst.h
enum
{
	DBC_BOX_NONE = 0 ,
	DBC_BOX_SE,
	DBC_BOX_SD,
	DBC_BOX_25_75,
	DBC_BOX_10_25_75_90,
	BSC_BOX_CONSTANT,
	DBC_NOTCHED_BOX,
};

enum
{
	DBC_WHISKER_BEGIN = 0,
	DBC_WHISKER_NONE = DBC_WHISKER_BEGIN,
	DBC_WHISKER_9010,
	DBC_WHISKER_9505,
	DBC_WHISKER_9901,
	DBC_WHISKER_SD,
	DBC_WHISKER_SE,
	DBC_WHISKER_OUTLIER,
	DBC_WHISKER_MAXMIN,
	DBC_WHISKER_CONSTANT,
	DBC_WHISKER_QUANTILE,
};
/// end MORE_WORK_ON_STATISTICAL_PLOTS




/// ML 5/17/2005 QA70-7686 X_FUNCTION_DRIVEN_MENUS_WITH_TREE
// Possible values/bits for the IDV_AUX_OPTIONS node in menu tree: 
enum {
	MENUTRAUXOPTS_ONE_OPTION_ONLY_MASK				= 0x00000007UL,			// If any of these bits is on, and the function supports
																			// options, only one menu item - the one for the option
																			// value (dw & MENUTRAUXOPTS_ONE_OPTION_ONLY_MASK) - 1 will be added.
	MENUTRAUXOPTS_USE_DESC_FOR_LABEL				= 0x00010000UL,
	MENUTRAUXOPTS_GET_ALL_FILES						= 0x00020000UL,			// If on, get the files in all the folders
	MENUTRAUXOPTS_PREFER_SYSTEM						= 0x00040000UL,			// Used only if MENUTRAUXOPTS_GET_ALL_FILES is off.
																			// If on, the order is : 1. System, 2. Group, 3. User
																			// Otherwise: 1. User, 2. Group, 3. System
	MENUTRAUXOPTS_NO_ADD_AS_TOOL					= 0x00080000UL,

	MENUTRAUXOPTS_OPTIONAL_INDEX_NO_POPUP			= 0x00100000UL,			// to prevent items for different options from going together into a separate
																			// subpopup.
	//---------- CPY ML 5/31/06 MRU_ANALYSIS_COMMANDS
	MENUTRAUXOPTS_USE_CAT_SUBCAT_FOR_POPUPS			= 0x00200000UL,	// use category string as 1st level popup and subcategory as second, and so on to add menus
	//----------													// this should be used with * in XF name
	/// ML 6/1/2006 OPTIONALLY_PUTTING_MULTIPLE_ITEMS_OF_ONE_NODE_INTO_SUBPOPUP
	MENUTRAUXOPTS_USE_CAT_SUBCAT_NO_POPUPS			= 0x00400000UL,			// similar to MENUTRAUXOPTS_USE_CAT_SUBCAT_FOR_POPUPS, except no popups 
	/// end OPTIONALLY_PUTTING_MULTIPLE_ITEMS_OF_ONE_NODE_INTO_SUBPOPUP

	MENUTRAUXOPTS_CHECK_SELECTION_PROTECT			= 0x00800000UL, /// SY 2007-02-13 QA70-9361 v8.0561 COL_LOCKED_CAN_NOT_INSERT
};
/// end X_FUNCTION_DRIVEN_MENUS_WITH_TREE


///DSC 3/4/05  MOVE_OC_THEME_FUNCTIONS_TO_VC
#define THEME_SUB_FOLDER	"Themes"
#define THEME_FILE_EXT				"oth"
#define ANALYSIS_THEME_FILE_EXT		"ois"
/// ML 4/21/2006 QA70-8634 USING_TAGNAMES_INSTEAD_OF_DATAIDS_IN_SOME_CASES
//#define MENU_THEME_FILE_EXT			"omc"	///DSC 7/6/05 QA70-7869 MENU_THEME
#define MENU_THEME_FILE_EXT			"xml"
/// end USING_TAGNAMES_INSTEAD_OF_DATAIDS_IN_SOME_CASES
#define XF_ANALYSIS_THEME_FILE_EXT	"oix"	///DSC 8/1/05 ANALYSIS_XF_THEME_TYPE

#define MENU_CUSTOMIZATION_FILE_EXT	"OMC"	///Kyle 07/02/2009 QA70-13423 NEW_FILE_TYPE_FOR_MENU_CUSTOMIZATION
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER
#define MENU_CUSTOMIZATION_CONFIGURATION_FILE			"OMC.INI"
///------ Folger 07/02/09 SUPPORT_OMC_FILE_PUBLISH_IN_GROUP_FOLDER_MANAGER


#define STR_PREFIX_SYSTEM 			okutil_get_origin_path_keyword(ORIGIN_PATH_SYSTEM)
#define STR_PREFIX_ALL_USER 		okutil_get_origin_path_keyword(ORIGIN_PATH_GROUP)
#define STR_PREFIX_USER				okutil_get_origin_path_keyword(ORIGIN_PATH_USER)
#define STR_PREFIX_UNDEF			okutil_get_origin_path_keyword(ORIGIN_PATH_UNDEF) /// DSC 10/28/2005 SUPPORT_ORIGIN_PATH_UNDEF
#define STR_PREFIX_NAME_SEP			": " // separator between prefix and name is Colon + space
///DSC 8/5/05 MORE_NEW_COMPOSITE_NAME_FORMAT
// #define STR_PREFIX_SYSTEM_SEP 		okutil_get_origin_path_keyword(ORIGIN_PATH_SYSTEM, STR_PREFIX_NAME_SEP)
// #define STR_PREFIX_ALL_USER_SEP 	okutil_get_origin_path_keyword(ORIGIN_PATH_GROUP, STR_PREFIX_NAME_SEP)
// #define STR_PREFIX_USER_SEP			okutil_get_origin_path_keyword(ORIGIN_PATH_USER, STR_PREFIX_NAME_SEP)

///DSC 8/5/05 centralize codes. Should not use these constants...use okutil_composite_name_from_components(...) instead
/*
#define STR_PREFIX_SYSTEM_SEP 		okutil_get_origin_path_keyword(ORIGIN_PATH_SYSTEM, true)
#define STR_PREFIX_ALL_USER_SEP 	okutil_get_origin_path_keyword(ORIGIN_PATH_GROUP, true)
#define STR_PREFIX_USER_SEP			okutil_get_origin_path_keyword(ORIGIN_PATH_USER, true)
*/
///end MORE_NEW_COMPOSITE_NAME_FORMAT
///end USE_ENUM_ORIGIN_PATH_TYPE

///DSC 8/5/05 code cleanup
//#define STR_SYS_FDF_PREFIX				STR_PREFIX_SYSTEM_SEP
//#define STR_ALL_USER_FDF_PREFIX			STR_PREFIX_ALL_USER_SEP	
//#define STR_USER_FDF_PREFIX				STR_PREFIX_USER_SEP
///

///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
enum {
	/// YuI 02/21/06 QA70-8549 NEW_COMPLEX_RANGE_CONTROL
	// looks like we need invalid
	// opening bracket < without closing one would be on case of invalid
	PDS_INVALID = -1, 
	/// end NEW_COMPLEX_RANGE_CONTROL
	PDS_USER, // user supplied string
	PDS_NEW,
	PDS_NO_NAME, 	///Jasmine 11/09/07 QA70-10621 USE_REAL_LAYER_NAME_NOT_INDEX 
	PDS_NONE,
	PDS_SOURCE,
	PDS_REPORT,
	PDS_FIT_CURVE,	///Jasmine 09/20/06 QA70-8973 MODIFICATION_OUTPUT_BRANCH
	/// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
	/////Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
	//PDS_CUSTOM,	
	/////--
	PDS_EXISTING,	
	PDS_CUSTOM = PDS_EXISTING,	
	/// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
	
	/// Iris 03/08/2007 NEED_DISTI_THREE_DOTS_AND_PAGE_NAME_AFTER_EXISTING_AND_SOURCE
	PDS_THREE_DOTS,
	///end NEED_DISTI_THREE_DOTS_AND_PAGE_NAME_AFTER_EXISTING_AND_SOURCE

	///DSC 3/25/03 CLEANUP_LAST_USED
	PDS_LAST_USED,
	PDS_FACTORY_DEFAULT,
	///end CLEANUP_LAST_USED

	PDS_ACTIVE, /// EJP 2005-04-15 v8.0223 CLEAN_ACTIVE_IMPLEMENTATION
	PDS_SAME, /// YuI 05/20/05
	PDS_UNASSIGNED, /// YuI 05/20/05
	PDS_OPTIONAL, /// YuI 08/12/05 QA70-8006 XFUNCTION_AND_TREE_VARIABLE
	PDS_INPUT, /// YuI 09/19/05 QA70-8119 SUPPORT_FOR_OUTPUT_TO_BE_SAME_AS_INPUT

	PDS_AUTO,	//---- CPY 7/10/06 QA70-8806 AUTO_SUPPORT_FOR_XF_VAR_VALUES
	
	PDS_BOOK,	/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	PDS_SHEET,	/// SY 2006-10-02 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
	
	PDS_LONG_NAME,	/// Iris 12/11/2006 EXPORT_PAGE_SUPPORT_MUL_PAGES
	PDS_SHORT_NAME,	/// Iris 12/11/2006 EXPORT_PAGE_SUPPORT_MUL_PAGES
	
	PDS_PROJECT_FOLDER,/// Jake 06/19/07 GET_PATH_TRACK_LIST_FROM_REGISTRY
	PDS_USER_FOLDER,   /// Jake 06/19/07 GET_PATH_TRACK_LIST_FROM_REGISTRY
	PDS_EXE_FOLDER,	/// Hong 12/06/07 v8.0762 IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
	
	PDS_TEMPLATE, //---- CPY 7/18/2007 QA70-10063-P3 XFBAR_LOADED_FROM_TEMPLATE_SHOULD_SHOW_THEM_AS_TEMPLATE

	PDS_DEFAULT, //------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT

	PDS_AUTO_X,		//---- CPY 7/31/08 QA70-11914-P10 SEPARATE_OUT_AUTO_X_INSTEAD_OF_AUTO_IN_SAMPLING_INTERVAL_X 

	PDS_FOLDER_LAST_USED,		///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

PDS_TOTAL
};
///end MOVE_GET_CLASS_SETTINGS_TO_VC

/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC	
#define STR_THEME_ORGANIZER_FILE_NAME		"themeOrganizer.xml"///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
#define TREE_THEME_BRANCH_FOLDER			"BranchThemes\\"///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
/// end MOVE_GET_CLASS_SETTINGS_TO_VC
	


/// ML 3/16/2005 QA70-7498 NEW_GROBJ_BASED_X_VARIABLE_TYPES
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// types are serialized
// NEW TYPES AT THE BOTTOM ONLY
// NEW TYPES AT THE BOTTOM ONLY
// NEW TYPES AT THE BOTTOM ONLY
// NEW TYPES AT THE BOTTOM ONLY
// NEW TYPES AT THE BOTTOM ONLY
// types are serialized
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

typedef	enum	tagXVARIABLETYPE
{
	/// ML 5/9/2005 RETURNING_VALUE_FROM_XFUNCTION
	/// RVD 5/9/2005 VOID_BAD_IDEA_MINUS_ONE_IS_ERROR
	//XVT_VOID				= -1,			// for return type only
	/// end VOID_BAD_IDEA_MINUS_ONE_IS_ERROR
	/// end RETURNING_VALUE_FROM_XFUNCTION
	XVT_DOUBLE,
	XVT_STRING,
	XVT_INT,
	XVT_VECTOR,
	XVT_DATARANGE,
	XVT_XYDATARANGE,
	XVT_MATRIX,
	XVT_XYZDATARANGE,
//	XVT_MATRIXOBJECT,
	XVT_BUTTONINFO,
	XVT_LINEINFO,
	XVT_TEXTINFO,
	XVT_EVENTINFO,
	XVT_MARKERINFO,	/// RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ
	XVT_RECTINFO,	/// RVD 11/22/2006 QA70-9148 v8.0515 IMPLEMENT_RECTINFO
	/// RVD 5/9/2005 VOID_BAD_IDEA_MINUS_ONE_IS_ERROR
	XVT_VOID, // for return type only
	/// end VOID_BAD_IDEA_MINUS_ONE_IS_ERROR
	
	/// YuI 05/11/05 XFUNCTION_ORIGINOBJECT_XVARIABLE
	XVT_ORIGINOBJECT,
	XVT_COLUMN,
	XVT_WORKSHEET,
	XVT_MATRIXOBJECT,
	XVT_DATAPLOT,
	/// end XFUNCTION_ORIGINOBJECT_XVARIABLE
	/// YuI 08/12/05 QA70-8006 XFUNCTION_AND_TREE_VARIABLE
	XVT_TREE,
	/// end XFUNCTION_AND_TREE_VARIABLE
	/// YuI 08/29/05 QA70-7921 FILE_IMPORTING_XFUCNTIONS
	XVT_FILELINK,
	/// end FILE_IMPORTING_XFUCNTIONS

	/// YuI 11/09/05 QA70-8279 REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	XVT_REPORTTREE,
	XVT_REPORTDATA,
	/// end REPORT_TREE_AND_REPORT_DATA_XVARIABLES
	
	/// YuI 03/21/06 PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
	XVT_GRAPHPAGE,
	XVT_WKSPAGE,
	XVT_MATRIXPAGE,
	XVT_GRAPHLAYER,
	XVT_MATRIXLAYER,
	/// end PAGE_GRAPH_LAYER_AND_OTHER_OOBJECT_VAR_TYPES
	
	/// YuI 03/24/06 STRING_VECTOR_X_VARIABLE
	XVT_VECTORSTRING,
	/// end STRING_VECTOR_X_VARIABLE
	
	/// YuI 03/30/06 COMPLEX_VECTOR_AND_RANGE_DATA_TYPES
	XVT_VECTORCOMPLEX,
	XVT_XYRANGECOMPLEX,
	/// end COMPLEX_VECTOR_AND_RANGE_DATA_TYPES

	XVT_PAGE, //CPY 8/14/2006 XF_VAR_PAGE_NEEDE_FOR_TEMPLATE_SAVE_AS

	/// YuI 08/30/06 QA70-8944 IMAGE_TYPE_XVARIABLE
	XVT_IMAGE,
	/// end IMAGE_TYPE_XVARIABLE

	//------ CPY 11/1/06 EXP_GRAPH_NEED_GRAPH_BASE
	XVT_GRAPHPAGE_BASE,    //LTT_ID_GRAPHPAGEBASE
	//------

	XVT_LAYER,	/// Kenny 06/18/2010 ORG-345-P1 ADD_LAYER_AS_XF_DATA_TYPE_FOR_XF_PALAPPLY
	
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// adding new types? 
	// dont forget to add new entries to enum for action objects
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// types are serialized
	// NEW TYPES AT THE BOTTOM ONLY
	// NEW TYPES AT THE BOTTOM ONLY
	// NEW TYPES AT THE BOTTOM ONLY
	// NEW TYPES AT THE BOTTOM ONLY
	// NEW TYPES AT THE BOTTOM ONLY
	// types are serialized
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	
}	XVARIABLETYPE;

//------ CPY 11/1/06 EXP_GRAPH_NEED_GRAPH_BASE
// seems that this is no longer used in OC
/*
/// YuI 02/21/06 QA70-8549 NEW_COMPLEX_RANGE_CONTROL
// the purpose of this enum is to create different enumeration
// which will refer to XVAR types mostly but will have additional memebrs
// that are not XVar types, but still needed (like for complex subrange and complex subrange leafs
typedef enum	tagINTERACTIVECONTROLACTIONOBJECT
{
	/// ML 4/25/2006 ACTION_OBJECT_COMPOSITE_NODES_ETC
	ICAO_NONE			= -1111,
	/// end ACTION_OBJECT_COMPOSITE_NODES_ETC
	ICAO_DOUBLE			= XVT_DOUBLE,
	ICAO_STRING			= XVT_STRING,
	ICAO_INT			= XVT_INT,
	ICAO_VECTOR			= XVT_VECTOR,
	ICAO_DATARANGE		= XVT_DATARANGE,
	ICAO_XYDATARANGE	= XVT_XYDATARANGE,
	ICAO_MATRIX			= XVT_MATRIX,
	ICAO_XYZDATARANGE	= XVT_XYZDATARANGE,
	ICAO_COLUMN			= XVT_COLUMN,
	ICAO_WORKSHEET		= XVT_WORKSHEET,
	ICAO_MATRIXOBJECT	= XVT_MATRIXOBJECT,
	ICAO_DATAPLOT		= XVT_DATAPLOT,
	ICAO_TREE			= XVT_TREE,
	ICAO_REPORTTREE		= XVT_REPORTTREE,
	ICAO_REPORTDATA		= XVT_REPORTDATA,
	ICAO_MATRIXPAGE		= XVT_MATRIXPAGE,
	ICAO_GRAPHPAGE		= XVT_GRAPHPAGE,
	ICAO_WKSPAGE		= XVT_WKSPAGE,
	ICAO_GRAPHLAYER		= XVT_GRAPHLAYER,
	ICAO_MATRIXLAYER	= XVT_MATRIXLAYER,
		  
	/// YuI 03/30/06 COMPLEX_VECTOR_AND_RANGE_DATA_TYPES
	ICAO_VECTORSTRING	= XVT_VECTORSTRING,
	ICAO_VECTORCOMPLEX	= XVT_VECTORCOMPLEX,
	ICAO_XYRANGECOMPLEX	= XVT_XYRANGECOMPLEX,
	/// end COMPLEX_VECTOR_AND_RANGE_DATA_TYPES

	/// YuI 08/30/06 QA70-8944 IMAGE_TYPE_XVARIABLE
	ICAO_IMAGE			= XVT_IMAGE,
	/// end IMAGE_TYPE_XVARIABLE

	//////////////////////////////////////
	// what follows are action types that do not have corresponding XVar type
	//ICAO_COMPOSITE_SUBRANGE = 1000,
	ICAO_SUBRANGE = 1000,
	ICAO_XY_SUBRANGE,
	ICAO_XYZ_SUBRANGE,
	ICAO_XYCOMPLEX_SUBRANGE,
	ICAO_COMPOSITE_SUBRANGE_LEAF,
	ICAO_COMPLEX_VECTOR_MAIN,

	/// YuI 05/26/06 NLSF_INPUT_DATA_EXPANDED_GUI
	ICAO_FITTER_DATA_ROOT,
	ICAO_FITTER_DATA_ONE_SET,
	ICAO_FITTER_DATA_INDEPENDENT,
	ICAO_FITTER_DATA_DEPENDENT,
	/// end NLSF_INPUT_DATA_EXPANDED_GUI
}	INTERACTIVECONTROLACTIONOBJECT;
/// end NEW_COMPLEX_RANGE_CONTROL
*/
//------- CPY 12/26/05 GETNGRAPH_BOX_TYPE_4
/// TD 5-30-06 QA70-8708 MORE_CROSS_EVENTS_FOR_XFNS
//#define XF_GETN_MAKE_TREE 2 // we are no longer using XF_GETN_GRAPH_PREVIEW, so it is reused for the make_tree event
enum
{
	XF_GETN_MAKE_TREE = 2,
	XF_GETN_BEFORE_EXECUTE,
	XF_GETN_EXTENDED_EVENT,	/// YuI 09/16/09 QA70-13696 XFUNCTION_EVENT2_IMPLEMENTATION
};

/// end MORE_CROSS_EVENTS_FOR_XFNS
//---- CPY 1/27/2008 QA70-10966 WIZARD_XF_NEED_SEPARATE_GETN
//enum {XF_GETN_NONE, XF_GETN_SIMPLE, XF_GETN_GRAPH_PREVIEW, XF_GETN_IMAGE, XF_GETN_GRAPH, 
#ifdef _NOT_WIZARD_GET_TYPE
	#define XF_GETN_GRAPH_OLD  XF_GETN_GRAPH
	enum {XF_GETN_NONE, XF_GETN_SIMPLE, XF_GETN_GRAPH_PREVIEW, XF_GETN_IMAGE, XF_GETN_GRAPH, 
#else
	#define XF_GETN_GRAPH_OLD 	(XF_GETN_IMAGE + 1)
	enum {XF_GETN_NONE, XF_GETN_SIMPLE, XF_GETN_GRAPH_PREVIEW, XF_GETN_IMAGE, XF_GETN_WIZARD, 
/// YuI 01/29/09 QA70-13034 CUSTOM_XF_DIALOGS
#ifdef CUSTOM_XF_DIALOG
	XF_GETN_CUSTOM,
#endif // CUSTOM_XF_DIALOG
/// end CUSTOM_XF_DIALOGS
#endif
//---- end WIZARD_XF_NEED_SEPARATE_GETN
XF_GETN_COUNT };
//-------

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
enum {XFSOR_VALDATA, XFSOR_EXTERNAL_DATA_RANGE, XFSOR_EXTERNAL_LT_VAR};
/// end XVARIABLEBASE_TO_VC

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
// error codes
/// YuI 04/06/06 BETTER_XFUNCTION_ERROR_HANDLING
//--------- CPY 6/22/06 CER
//------------- Origin C Common Error Codes ---------------------------
//----------------------------------------------
//------ CPY 7/6/06 QA70-8088 CENTRALIZED_ERR_MSG_DLL
// moved to oErrMsg.h
/*
typedef enum tagCOMMON_ERR_CODES
{
	XFERR_BEGIN = 1000,
	XFERR_RUNTIME_EXCEPTION = XFERR_BEGIN, // this is thrown with message XF_THROW2("Message")
	XFERR_MATOBJ_COPY_FAILED, 
	XFERR_INTOPTN_OUT_OF_RANGE,
	XFERR_MATOBJ_FAILED_LT_BMP,
	XFERR_UI_USER_CANCEL,
	XFERR_INVALID_ARG,
	XFERR_NO_ACTIVE_SHEET,
	
///Echo 6/22/06 GLOBAL_ERROR_HANDLING CPY 6/22/06 moved here
	XFERR_END = 1299,
	CER_BEGIN,
	CER_NO_DATA = CER_BEGIN, // CPY 6/22/06, allow 1000-1299 as XF specific errs
	CER_DATA_TOO_FEW, 
	CER_DATA_TOO_MANY,
	CER_COL_NUM_NOT_ONE,
	CER_COL_NUM_NOT_TWO,
	CER_GROUP_NUM_NOT_TWO,
	
	CER_END = 1999	//CPY 6/22/06, total of 700 common err codes, should be enough
///end GLOBAL_ERROR_HANDLING

} COMMON_ERR_CODES;
*/
//--------- end CPY 6/22/06 CER

#define		MATOBJ_COPY_FAILED		XFERR_MATOBJ_COPY_FAILED
#define		INTOPTN_OUT_OF_RANGE	XFERR_INTOPTN_OUT_OF_RANGE
#define		MATOBJ_FAILED_LT_BMP	XFERR_MATOBJ_FAILED_LT_BMP
/// end BETTER_XFUNCTION_ERROR_HANDLING

enum {
	CCS_ERR_GOOD_C_NAME_NOT_LT_STR_VAR = -6, //---- CPY 6/23/06 XOF_BROKEN
	CCS_ERR_COL_VAR = -5,
	CCS_ERR_OBJ_VAR = -4,
	CCS_ERR_STRFUNC_VAR = -3,
	CCS_ERR_EXPRESSION = -2,
	CCS_ERR_LTVAR_NOT_FOUND = -1, 
	CCS_NO_CHANGE = 0, 
	CCS_NO_CHANGE_GOOD_C_NAME, 
	CCS_QUOTE_REMOVED, 
	CCS_LTVAR_SUBSTITUDED, 
	CCS_STR_EXPRESSION_RESOLVED,
	CSS_LT_GLOBAL_STR_SUBSTITUDED,
};



// dwOpts for push and pop:
enum XFPUSHPOP {
	XFPUSHPOP_SUCCESS		= 0x00000001,
	
	XFPUSHPOP_UNDO			= 0x00010000,
};
/// end XVARIABLEBASE_TO_VC


/// ML 2/10/2006 QA70-8490 NEW_VC_TREE_CONTROL

/// YuI 02/06/07 redefining entire enum, CP introduced collisions
/*
enum {
	GRID_CHANGE_SHOW =						0x0001,
	GRID_CHANGE_ENABLE =					0x0002,
	GRID_CHANGE_VALUE =						0x0004,
	GRID_CHANGE_SIZE =						0x0008,
	GRID_CHANGE_COMBOSTR =					0x0010, //---- CPY v7.5785 12/19/03 QA70-5738 GETN_BOX_COMBO_CHANGE_NEEDED
	GRID_CHANGE_TREE_STRUCTURE =			0x0040,/// YuI 09/22/05 GETN_BUTTON_BRANCH_OPTION

//---- CPY 02/05/07 GETN_DLG_ADD_MORE_BUTTON_EVENT
//	GRID_CHANGE_DISABLE_OK =				0x1000,//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	//bits to control buttons
	GETNGEVT_OK_ENABLE					=	0x0010,
	GETNGEVT_ENABLE_CUSTOM_BUTTON1		=	0x0020,
	GETNGEVT_ENABLE_CUSTOM_BUTTON2		=	0x0040,
	GETNGEVT_ENABLE_CUSTOM_BUTTON3		=	0x0080,
//----
	GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE =	0x2000, //CPY 8/27/04 QA70-5890 v8.0125 BRANCH_ALLOW_CHECKBOX  //------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS moved to high bit

	GETNGEVT_GRID_NEED_UPDATE			=	0x0100,	 //---- CPY 02/05/07 GETN_DLG_ADD_MORE_BUTTON_EVENT
	GETNGEVT_GRAPH_NEED_UPDATE			=	0x0200,	 //---- CPY 02/05/07 GETN_DLG_ADD_MORE_BUTTON_EVENT

	GRID_CHANGE_LAST_ENTRY
};
*/

enum {
	GRID_CHANGE_SHOW =						0x0001,
	GRID_CHANGE_ENABLE =					0x0002,
	GRID_CHANGE_VALUE =						0x0004,
	GRID_CHANGE_SIZE =						0x0008,
	GRID_CHANGE_COMBOSTR =					0x0010,
	GRID_CHANGE_TREE_STRUCTURE =			0x0020,
	GRID_CHANGE_LABEL =						0x0040, //----- CPY 4/20/07 QA70-9602 LABEL_CHANGE_SHOULD_NOT_TRIGGER_INIT_EVENT
	GRID_CHANGE_NUM_FORMAT =				0x0080,		 ///------ Folger 02/09/09 QA80-12786 NODE_NUMBER_FORMAT_CHANGE_SHOULD_UPDATE_DYNACONTROL_BY_SET_TREE

	GRID_CHANGE_GROUP_BRANCH =				0x10000000,		///------ Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING

	//----------------------------------------------
	//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
	//GETNGEVT_OK_ENABLE					=	0x0100,
	//GETNGEVT_ENABLE_CUSTOM_BUTTON1		=	0x0200,
	//GETNGEVT_ENABLE_CUSTOM_BUTTON2		=	0x0400,
	//GETNGEVT_ENABLE_CUSTOM_BUTTON3		=	0x0800,
	//----- CPY 4/20/07 QA70-9602 LABEL_CHANGE_SHOULD_NOT_TRIGGER_INIT_EVENT
	//GETNGEVT_OK_ENABLE					=	0x0080,
	//-----
	//Sim 04-12-2007 Custom Button Enable Bits must be continuous, they are used by macro CUSTOM_BUTTON_TO_GETN_ENABLE(_NN) in GetNBox.h
	GETNGEVT_ENABLE_CUSTOM_BUTTON1		=0x00000100,
	GETNGEVT_ENABLE_CUSTOM_BUTTON2		=0x00000200,
	GETNGEVT_ENABLE_CUSTOM_BUTTON3		=0x00000400,
	GETNGEVT_ENABLE_CUSTOM_BUTTON4		=0x00000800,
	//-------- end ADDING_CUSTOM_BUTTON4
	////----------------------------------------------
	//----- CPY 4/20/07 QA70-9602 LABEL_CHANGE_SHOULD_NOT_TRIGGER_INIT_EVENT
	//GETNGEVT_GRID_NEED_UPDATE			=	0x1000,
	//GETNGEVT_GRAPH_NEED_UPDATE			=	0x2000,
	//GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE =	0x4000,
	GETNGEVT_OK_ENABLE					=0x00004000,
	GETNGEVT_GRID_NEED_UPDATE			=0x00010000,
	GETNGEVT_GRAPH_NEED_UPDATE			=0x00020000,
	GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE =0x00040000,
	//-----
	GETNGEVT_GRAPH_ERROR				=0x00080000, ///---Sim 07-12-2007 EXTEND_UPDATE_GRAPH_CONTROL_VALUE
	///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	GETNGEVT_APPLY_ENABLE				=0x00100000,
	GETNGEVT_UNDO_ENABLE				=0x00200000,	
	///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
	GETNGEVT_GRID_NEED_RESET			= 0x00400000,		///------ Folger 04/14/09 QA80-12786-P3 PREVIEW_GETN_FAILS_TO_SHOW_DATA_TIME_FORMAT_AFTER_CHANGED
};

/// Hong 11/10/07 QA80-10664 FIX_AUTO_CONTROL_FAIL_UPDATE_IF_HAVE_EVENT_HANDLER
//------ CPY 04/05/09 QA80-10664 PER_YURI_XYRANGE_X_Y_FIELD_EDIT_TROUBLE
//------ CPY 04/07/09 temp change back to old for SR5, if removing GRID_CHANGE_SIZE, too many XF will be broken, so we will properly fix this after SR5
#define GRID_CHANGE_COMMAN_UPDATE_BITS		(GRID_CHANGE_SIZE | GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE)
//#define GRID_CHANGE_COMMAN_UPDATE_BITS		GRID_CHANGE_SKIP_HANDLERS_ON_UPDATE
//The above change is from Yuri's email
//
//There are problems with typing into child dyna control
//To reproduce:
//Without any selection bring up integ1 dialog
//Expand input control all the way to X and Y leafs
//Type col(a) into X leaf, after that try to type col(b) into Y leaf
//First immediately after you start typing in Y leaf
//DynaControl will begin flickering on every key press.
//Once you reach "(" in "col(b)" you will not be able to proceed further.
// bascically, the test if(wParam & GRID_CHANGE_DYNA_ANY_CHANGE) is supposed to catch any change like GRID_CHANGE_SHOW, GRID_CHANGE_SIZE, but since Hong made GRID_CHANGE_SIZE
// included into default, GRID_CHANGE_COMMAN_UPDATE_BITS, then it will get into that if(wParam & GRID_CHANGE_DYNA_ANY_CHANGE) unnecessarily
// Removing GRID_CHANGE_SIZE will revert back to original meanning of GRID_CHANGE_DYNA_ANY_CHANGE and we will separately find what this will break and fix separately
//------ end PER_YURI_XYRANGE_X_Y_FIELD_EDIT_TROUBLE

/// end FIX_AUTO_CONTROL_FAIL_UPDATE_IF_HAVE_EVENT_HANDLER
///------ Folger 04/14/09 GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
//#define GRID_CHANGE_DYNA_ANY_CHANGE			0x00FF	//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS 
#define GRID_CHANGE_DYNA_ANY_CHANGE			0xF00000FF	//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS 
///------ End GROUP_BRANCH_LABEL_FAILS_TO_UPDATE_DYNAMICALLY_IN_2DBINNING
/// TD 2-14-06 QA70-8490 GETN_EVENTS_IN_TREE_DLG
enum {
	GETNEVENT_VIEW_LIST 			= 0x0001,	// in grid-list view mode, if not set, then in Tree view mode
	///DG VIEW_GRAPH_GETNBOX
	GETNEVENT_UPDATE_GRAPH			= 0x0002,
	GETNEVENT_UPDATE_PREVIEW		= 0x0004,
	GETNEVENT_UPDATE_GUI_TREE		= 0x0008,
	///end VIEW_GRAPH_GETNBOX
	GETNEVENT_ON_GRAPH_OBJECT		= 0x0010, /// Iris 02/06/2007 v8.0556 CALL_EVENT1_ON_GRAPH_OBJ_MOVING
	GETNEVENT_ON_EXTERNAL_MSG		= 0x0020, ///---Sim 06-29-2007 SUPPORT_SENT_MESSAGE_FROM_EXTERNAL_WINDOW
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//must not shard bits with GETNEVENT_ON_ANY(0x0F00), as GETNEVENT_ON_RECONSTRUCT and GETNEVENT_ON_INIT can be used together at same times
	///---Sim 10-17-2008 QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE change a more appropriate name
	//GETNEVENT_ON_RECONSTRUCT		= 0x0040, 
	GETNEVENT_ON_GUI_CHANGED		= 0x0040, // means this event from dialog GUI change
	///---END QA80-12345-P1 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//------ CPY 7/3/06 QA70-8798 DYNABOX_BETTER_EVENTS
	//GETNEVENT_ON_SETUP				= 0x0100,	//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET, call before controls are initialized
	//GETNEVENT_ON_INIT 				= 0x4000,	// to indicate event is called during initialization, if not set, then event is triggered on change
	GETNEVENT_ON_SETUP				= 0x0100,
	GETNEVENT_ON_INIT				= 0x0200, // need to match with GETNE_ON_INIT
	GETNEVENT_ON_OK					= 0x0300, // need to match with GETNE_ON_OK
	GETNEVENT_ON_APPLY				= 0x0400,
	GETNEVENT_ON_THEME				= 0x0500, //CPY Iris 7/20/06 v8.0447 SEPRATE_INIT_AND_THEME_EVENT
	GETNEVENT_ON_DESTROY			= 0x0600, //---- CPY 10/24/06 XF_DLG_DESTROY_EVENT
	///Jasmine 02/01/07 GETN_PREVIEW_DLG_NEED_MORE_BTNS
	GETNEVENT_ON_CUSTOM_BUTTON1		= 0x0700,
	GETNEVENT_ON_CUSTOM_BUTTON2		= 0x0800,
	GETNEVENT_ON_CUSTOM_BUTTON3		= 0x0900,
	GETNEVENT_ON_CUSTOM_BUTTON4		= 0x0A00, //-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
	///End GETN_PREVIEW_DLG_NEED_MORE_BTNS
	GETNEVENT_ON_CHANGE_UPDATE_GUI  = 0x0E00,	///Joseph 02/14/07 SUPPORT_MORE_SPECAIL_EVENT CPY 4/21/07 renamed from GETNEVENT_CHANGE_UPDATE_GUI_TREE
	GETNEVENT_ON_ANY				= 0x0F00,
	//------
	/// AW 05/23/07 QA80-9821 v8.0622 SUPPORT_GETN_OC_EVENT
	GETNEVENT_ON_OC_SPECIFY			= 0xF000,
	/// END  SUPPORT_GETN_OC_EVENT
};
/// end GETN_EVENTS_IN_TREE_DLG
//---- CPY 02/05/07 GETN_DLG_ADD_MORE_BUTTON_EVENT
/*
///---------- Jasmine 02/03/07 ENABLE_CUSTOM_BUTTONS_SEPARATELY
#define GETNGEVT_GRID_NEED_UPDATE 		0x0001
#define GETNGEVT_GRAPH_NEED_UPDATE 		0x0002
//bits to control buttons
#define GETNGEVT_OK_ENABLE				0x0004	//--- CPY 7/2/2006 QA70-8798 OK_BUTTON_DISABLED_BY_EVENT
#define GETNGEVT_ENABLE_CUSTOM_BUTTON1	0x0008
#define GETNGEVT_ENABLE_CUSTOM_BUTTON2	0x0010
#define GETNGEVT_ENABLE_CUSTOM_BUTTON3	0x0020
*/
///---Sim 07-27-2007 IMPLEMENT_APPLY_AND_UNDO_MECHANISM
//#define GETNGEVT_ENABLE_ALL_BUTTONS		(GETNGEVT_OK_ENABLE | GETNGEVT_ENABLE_CUSTOM_BUTTON1 | GETNGEVT_ENABLE_CUSTOM_BUTTON2 | GETNGEVT_ENABLE_CUSTOM_BUTTON3 | GETNGEVT_ENABLE_CUSTOM_BUTTON4)
#define GETNGEVT_ENABLE_ALL_BUTTONS		(GETNGEVT_OK_ENABLE | GETNGEVT_APPLY_ENABLE | GETNGEVT_UNDO_ENABLE | GETNGEVT_ENABLE_CUSTOM_BUTTON1 | GETNGEVT_ENABLE_CUSTOM_BUTTON2 | GETNGEVT_ENABLE_CUSTOM_BUTTON3 | GETNGEVT_ENABLE_CUSTOM_BUTTON4)
///---END IMPLEMENT_APPLY_AND_UNDO_MECHANISM
#define CUSTOM_BUTTONS_COUNT	4	//-------- CPY 2/24/2007 ADDING_CUSTOM_BUTTON4
//---------- end ENABLE_CUSTOM_BUTTONS_SEPARATELY
/////End ENABLE_CUSTOM_BUTTONS_SEPARATELY

#define		WM_USER_TREEEDITOR_VALUE_CHANGE	(WM_USER + 1001)

//--- CPY 5/20/06 CHANGE_GETN_PREVIEW_TO_DATASHEET_FROM_WKSHEET
#define XFGSETUP_IMAGEGRAPH_CNTRL 	0x0001 // this will indicate matrix + image plot, otherwise default is to use wks+line graph control
#define XFGSETUP_MATRIX_CNTRL 		0x0002 //matrix control, image mode		///jasmine 08/06/10 ORG-389 ADD_MATRIX_IMAGE_PREVIEW
#define XFGSETUP_2_TABS				0x1000 // default is only 1 tab, so we support 1 or 2 tabs in GetNPreviewDlg
#define XFGSETUP_EMF_1ST			0x0100	// EMF control as 1st tab
#define XFGSETUP_EMF_2ND			0x0200	// EMF control as the 2nd tab, must also set XFGSETUP_2_TABS
//---


enum {HANDLER_MSG_NOT_POSTED, HANDLER_MSG_POSTED, HANDLER_NOT_CALLED}; ///Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC

/// end NEW_VC_TREE_CONTROL
/// TD 6-2-06 QA70-8708 CALLING_BEFORE_EXECUTE_EVENT
enum{
	XFEVT_PROCEED, 
	XFEVT_ABORT, 
	XFEVT_PROCEED_NO_DLG,
	XFEVT_PROCEED_WITH_DLG, //----- CPY 4/15/2007 QA70-9627 XF_BEFORE_EXEC_TO_ASK_DLG_TO_OPEN
};
/// end CALLING_BEFORE_EXECUTE_EVENT

///---Sim 07-23-2007 NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD
#define XF_PANEL_BINARY_STORAGE_NAME "XFBar"
///---END NOT_ALLOW_HIDE_XF_PANEL_FOR_WIZARD

//------ Folger 11/05/07 SAVE_XF_DIALOG_INFO_IN_PAGE_STORAGE
#define XF_DIALOG_BINARY_STORAGE_NAME "XFDialog"
//------ End SAVE_XF_DIALOG_INFO_IN_PAGE_STORAGE

/// ML 2/17/2006 INTERACTIVE_CONTROL_MENUS
#define IFI_BINARY_STORAGE_NAME "Files"
#define IFI_FILE_NODE_ENUM_NAME "File%d"
/// end INTERACTIVE_CONTROL_MENUS

/// Hong 02/04/10 QA8015063 FIX_FAIL_ACCESS_WKS_COL_FILE_INFO_IN_LT
//#define SIFI_BINARY_STORAGE_NAME "File"				///Kyle 02/04/2010 READ_COLUMN_INPORT_FILE_INFO
/// end FIX_FAIL_ACCESS_WKS_COL_FILE_INFO_IN_LT

/// Kenny 06/25/2009 QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE, share with VC
#define IFI_DATA_RANGE_NODE_NAME					"DataRange"
#define IFI_COVERED_BY_ANOTHER_IMPORT_NODE_NAME		"CoveredByAnotherImport"
#define IFI_COVERED_BY_ANOTHER_IMPORT_NEGATIVE_VAL	"No"
/// End QA80-12996-P5 CLEAR_OVERLAPPED_RANGE_FOR_SAVING_ANALYSIS_TEMPLATE

/// ML 4/21/2006 QA70-8634 USING_TAGNAMES_INSTEAD_OF_DATAIDS_IN_SOME_CASES
#define			STR_MTR_SEPARATOR_TAG		"sep"
#define			STR_MTR_NAME_TAG			"name"
#define			STR_MTR_AUXOPTS_TAG			"auxopts"
#define			STR_MTR_ACCEL_TAG			"accel"
#define			STR_MTR_BRANCH_ATT			"popup"
/// ML 10/19/2006 ADDING_NON_XFUNC_MENU_ITEMS_VIA_MENU_TREE
#define			STR_MTR_ITEM_ID				"CmdId"
/// end ADDING_NON_XFUNC_MENU_ITEMS_VIA_MENU_TREE
/// end USING_TAGNAMES_INSTEAD_OF_DATAIDS_IN_SOME_CASES
#define 		XF_LOCAL_ERR_BEGIN	10
#define STR_COL_FORMULAR_SEPARATOR ";\r\n#"	   //--CPY 5/1/06

/// ML 6/7/2006 QA70-4434 CUSTOM_TABLES_FOR_FIND_XY
// It holds file and section name, not the formual itself:
#define			STR_ATT_COLUMN_FORMULA		"COLFORMULA"
/// end CUSTOM_TABLES_FOR_FIND_XY
/// ML 11/13/2006 QA70-9125 SETREPORTTREE_SETTING_COLUMN_DIGITMODE_DIGITS
#define			STR_NUM_DISPLAY_FMT			"NumDisplayFormat"
/// end SETREPORTTREE_SETTING_COLUMN_DIGITMODE_DIGITS

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
//---- CPY 5/25/2007 QA70-9839 NLSF8_LT_VAR_FOR_FIT_CALL_BACK
// I moved these here as I think sooner or later we will need to call them from OC
/* WCB_* messages must all be bigger than WM_DLL_END which is 1424
 * and smaller then WM_DLL_BEGIN which is 1124
 */
#define	MASK_WCB_TYPE			0xF000
#ifndef MASK_WCB_NO_HWND  //CPY 6/19/08, might be already defined in oc_types.h
#define	MASK_WCB_NO_HWND		0x1000///
#endif
#define	MASK_WCB_OPTION_HWND	0x2000///


#define	MASK_DATASET			0x3000///
#define	MASK_DATASET_SERIES		0x0400

#define	MASK_FIT				0x4000///

#define	MASK_NEED_DRAW			0x5000///
#define	MASK_DRAWING_MODE		0x0400 // share DATA_SERIES 
	// must in between _BEGIN and _END
#define	MASK_DRAWING_OPTN_COOR	0x0800

#define	MASK_WCB_WKS			0x6000///CPY v4.05 3/8/96 WCB_WKS_HANDLING
#define	MASK_PKFIT				0x8000///
#define MASK_FRAME				0x9000
///

#define MASK_LT_STACK			0xA000
enum {
	// stack push and pop, no arg, return 0 if ok
	WCB_LT_STACK_PUSH = MASK_LT_STACK,
	WCB_LT_STACK_POP,

	// double values return 0 if ok, err codes < 0
	WCB_LT_STACK_ADD_DOUBLE, 
		//add variable or just change value of an existing one
		//lpstr:  the variable name (may be lowercase, but should be case-insensitive)
		//lParam: (double*) pointer to the double value of the variable
	WCB_LT_STACK_GET_DOUBLE,
		//lpstr:  the variable name (may be lowercase)
		//lParam: (double*) pointer to the double to receive the value

	// more general var control
	WCB_LT_STACK_REMOVE_VAR,
		//remove variable from local stack 
		//lpstr: the variable name (may be lowercase, but should be case-insensitive)
};
//---- end CPY 5/25/2007 QA70-9839 NLSF8_LT_VAR_FOR_FIT_CALL_BACK
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////


//--- CPY 7/19/06 SYS_COLORS
// we actually cannot change this list of colors
enum {
	SYSCOLOR_BLACK,	SYSCOLOR_RED,		SYSCOLOR_GREEN,		SYSCOLOR_BLUE,	SYSCOLOR_CYAN,		SYSCOLOR_MAGENTA,
	SYSCOLOR_YELLOW,SYSCOLOR_DKYELLOW,	SYSCOLOR_NAVY,		SYSCOLOR_PURPLE,SYSCOLOR_WINE,		SYSCOLOR_OLIVE,
	SYSCOLOR_DKCYAN,SYSCOLOR_ROYAL,		SYSCOLOR_ORANGE,	SYSCOLOR_VIOLET,SYSCOLOR_PINK,		SYSCOLOR_WHITE,
	SYSCOLOR_LTGRAY,SYSCOLOR_GRAY,		SYSCOLOR_LTYELLOW,	SYSCOLOR_LTCYAN,SYSCOLOR_LTMAGENTA,	SYSCOLOR_DKGRAY};
//----


/// ---- AW 10/03/06 QA80-9015 v8.0493 ADD_THEME_BRANCH_IN_XF 
enum {
	 THEME_SAVE_TO_SHEET = 0x00001,
	 THEME_SAVE_TO_BOOK = 0x00002,
};
/// ---- END ADD_THEME_BRANCH_IN_XF 

//------- CPY 6/7/2007 MOVE_SYS_XFC_TO_EXE_PATH
#define OCEXT_XFUNCTION					"XFC"	/// TD 2-14-05 QA70-7403 XFUNCTION_IDE
//-------

//----- CPY 6/15/07	QA70-9929 COLOR_1_OFFSET_FROM_DYNA_CNTRL	
#define MAX_BUILT_IN_COLORS 24
//----- 

//----- CPY 8/14/2007 QA70-10219 TEMPLATE_SEARCH_USER_GROUP_EXE
// moved these here from gStat.h
#define GLOBAL_DOC_PATH                 ('X' - 'A')
#define GLOBAL_INI_PATH                 ('Y' - 'A')
#define GLOBAL_PROG_PATH                100
#define GLOBAL_DLL_PATH                 101 // added for 3.65, dsb
/// ML 5/6/99 t6250 READING_OGO_OGI_FILES_FROM_CLIENTPATHS_FOR_NETWORK
#define	GLOBAL_OGO_PATH					GLOBAL_INI_PATH
#define	GLOBAL_OGI_PATH					GLOBAL_OGO_PATH
/// end READING_OGO_OGI_FILES_FROM_CLIENTPATHS_FOR_NETWORK

// DSB v3.80 & v3.7844 7/26/95 TEMP_PATH 
#define GLOBAL_TEMP_PATH				102 

#define GLOBAL_HELP_FILE                105
#define GLOBAL_INI_FILE                 106
#define GLOBAL_TEMPLATE_PATH            107 // added for 3.65, dsb

/// EJP 03-07-97 SUPPORT_FOR_MODLL_SYSTEM_OBJECT
#define GLOBAL_PATH_ASCII				108
#define GLOBAL_PATH_EXCEL				109
#define GLOBAL_PATH_PROJECT				110
#define GLOBAL_PATH_SIGMAPLOT			111
/// end SUPPORT_FOR_MODLL_SYSTEM_OBJECT

///DSC 2/14/07 CREATE_GLOBAL_GROUP_PATH
//#define GLOBAL_GROUP_PATH		113	   //------ CPY 9/25/2007 QA70-10417 GROUP_PATH_SHOULD_BE_EMPTY_UNLESS_GROUP_CLIENT
///end CREATE_GLOBAL_GROUP_PATH

///DSC 8/14/07 QA70-10217 VIEW_LICENSE_AGREEMENT_IN_ORIGIN
#define GLOBAL_LOCALIZED_PATH		114	 // Localized\[E,J,G,C]\  // examples Help\Origin.chm and Help\EvaluationToProduct.txt, ThirdPartyComponents.txt
///end VIEW_LICENSE_AGREEMENT_IN_ORIGIN

#define	GLOBAL_SYS_TMP_PATH			115		///------ Folger 08/12/09 QA80-14130 NEW_UFF2_AS_SYSTEM_TEMP_NEEDED

//-----end TEMPLATE_SEARCH_USER_GROUP_EXE

/// Hong 08/15/07 v8.0682 PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING
#define STR_FILTER_INI_FILENAME			"Filter.ini" // move and modify from sys_utils.c
//-- move from fu_utils.h
#define	IMPORT_FILTER_EXTENSION_WILD			"*.oif"
#define	FILTERS_FOLDER_NAME						"Filters\\"
#define	IMPORT_FILTER_EXTENSION					"oif" 
//--
/// end PUBLISH_FILTER_WITH_DRAG_AND_GROP_SETTING

/// Hong 09/14/07 QA80-10111 GROUP_DEFAULT_TO_UFF_SUBFOLDER
#ifndef	GROUP_FOLDER_SUB_EXE_PATH
	#define GROUP_PATH_SECTION	"Group Folder"
	#define GROUP_PATH			"Path"
#endif //GROUP_FOLDER_SUB_EXE_PATH
/// end GROUP_DEFAULT_TO_UFF_SUBFOLDER

//----- CPY 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
#define STR_DEBUG_SUBPATH "DebugInfo\\"
//-----

/// ML 12/5/2007 QA70-10780 DBG_TREES_IN_RELEASE
enum {
	GLBDBG_GENERATEREPORT_FILTERING			= 0x00000001,
};
/// end QA70-10780 DBG_TREES_IN_RELEASE



/// ML 1/25/2008 QA70-10972-P4 ADO_EXCEPTION_ON_EMPTY_RECORDSET
// Error codes for the Worksheet method PutRecordset()
/** >Internal Origin Objects>Worksheet
	Error codes for the Worksheet method PutRecordset()
*/
enum PRSTATUS {
	PUTRSET_OK								= 0,			// success
	PUTRSET_ERR_GENERAL						= -55000,		// general error
	PUTRSET_ERR_EMPTY_RECORDSET,							// empty recordset
};
/// end ADO_EXCEPTION_ON_EMPTY_RECORDSET

///---Sim 09-08-2008 DEFAULT_VERSION_NUMBER_FOR_XF_WIZARD
#define DEFAULT_VERSION_NUMBER 1.0
///---END DEFAULT_VERSION_NUMBER_FOR_XF_WIZARD

#define CHAR_UNSAVE_SIGN '*' ///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE

///------ Folger 12/30/09 QA81-14903 MRU_MENU_FOR_QUICK_FIT
#define		QUICK_FIT_ENTRY_NAME		_OL("Quick Fit")
/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
/*
#define		LINEAR_FIT_MRU_NAME			_OL("Linear")
#define		QUADRATIC_FIT_MRU_NAME		_OL("Quadratic")
#define		CUBIC_FIT_MRU_NAME			_OL("Cubic")
*/
///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
///------ End MRU_MENU_FOR_QUICK_FIT

#define		STR_EXPGRAPH_SPEEDMODE_SETTINGS				_OL("Apply Page Setting|On|Off")
#define		L_STR_EXPGRAPH_SPEEDMODE_SETTINGS			_LL("Apply Page Setting|On|Off")

///Kyle 08/23/2010 ORG-338-S1 SHOW_PAGE_ORIGINAL_SIZE_AS_HINT
#define		L_STR_LABEL_ORIGINAL_PAGE_SIZE					_LL("Original Page Size")
#define		L_STR_LABEL_EXPORT_PAGE_SIZE					_LL("Clipped Page Size")
///End SHOW_PAGE_ORIGINAL_SIZE_AS_HINT

///Kyle 02/26/2010 QA80-15138 KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC
#define STR_OMC_VERSION_ATTRIB									"version"

#define OMC_VERSION_HIDE_BUILT_IN_MENU_LIST_BY_INDEX			0
#define OMC_VERSION_HIDE_BUILT_IN_MENU_LIST_KEEP_MENU_TAG		0x00000001
///End KEEP_MENU_TAG_FOR_HIDE_BUILT_IN_MENU_LIST_TO_INDICATE_THE_POPUP_INDICES_IN_OMC

#define 	STR_INPUT_RANGE_NAME					"InputData"
#define 	STR_INPUT_RANGE_LABEL					_LE("Input Data")

#define		L_STR_EMPTY								_LL("Empty")			///Kyle 03/30/2010 QA80-15216 FUNCTION_MENU_FOR_FUNCTION_PLOT

///------ Folger 06/23/10 ORG-365-P4 MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS
#define		STR_ROW_INDEX							_OL("Row Index")
///------ End MORE_FLEXIBLE_CUSTOMIZED_ON_DATA_INFO_ROWS

///------ Folger 08/19/10 ORG-756-P3 BETTER_CHECKING_FOR_VALID_EQUATIONS
#define		STR_DERIVED_PARAM						_OL("derived parameter")
///------ End BETTER_CHECKING_FOR_VALID_EQUATIONS

///Sophy 11/2/2010 ORG-580 ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
enum {
	SEMITRANS_DRAW_OPAQUE					= 0,
	SEMITRANS_DRAW_RASTER_DEFAULT_RES		= 1,
	SEMITRANS_DRAW_RASTER_CUSTOMIZED_RES	= 2,
};
///end ADD_EPS_OPTION_TO_SUPPORT_EXPORT_GRAPH_WITH_RASTER_EMBEDDING
///------ Folger 08/19/10 ORG-279-P24 LOCALIZATION_FOR_SEMITRANSPARENT_IN_EXPGRAPH
#define		STR_SEMITRANSPARENT_AREA				_OL("Semi-transparent Regions")
#define		STR_SEMITRANSPARENT_OPTIONS				_OL("Draw as Opaque|Draw as Raster with Default Resolution|Draw as Raster")
///------ End LOCALIZATION_FOR_SEMITRANSPARENT_IN_EXPGRAPH

#endif //_OC_SYS_H_



